package com.yd.user.service.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.user.feign.request.relprojectmenu.ApiRelProjectMenuImportQueryMenuTreeRequest;
import com.yd.user.feign.request.relprojectmenu.ApiRelProjectMenuListPageRequest;
import com.yd.user.feign.request.relprojectmenu.ApiRelProjectMenuTreeListRequest;
import com.yd.user.feign.response.relprojectmenu.ApiRelProjectMenuImportQueryMenuTreeResponse;
import com.yd.user.feign.response.relprojectmenu.ApiRelProjectMenuListPageResponse;
import com.yd.user.feign.response.relprojectmenu.ApiRelProjectMenuTreeListResponse;
import com.yd.user.service.model.RelProjectMenu;
import org.apache.ibatis.annotations.Param;
import java.util.List;

/**
 * <p>
 * 项目-菜单关系表（正常来说一对多，加关系表方便扩展） Mapper 接口
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
public interface RelProjectMenuMapper extends BaseMapper<RelProjectMenu> {

    IPage<ApiRelProjectMenuListPageResponse> page(@Param("page") IPage<ApiRelProjectMenuListPageResponse> page,
                                                  @Param("request") ApiRelProjectMenuListPageRequest request);

    List<ApiRelProjectMenuTreeListResponse> treeList(@Param("request") ApiRelProjectMenuTreeListRequest request);

    List<ApiRelProjectMenuImportQueryMenuTreeResponse> importQueryMenuTreeList(@Param("request") ApiRelProjectMenuImportQueryMenuTreeRequest request);
    
}
