package com.yd.user.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 项目信息表
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
@Getter
@Setter
@ToString
@TableName("sys_project")
public class SysProject implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 项目ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 项目唯一标识(业务ID)
     */
    @TableField("project_biz_id")
    private String projectBizId;

    /**
     * 作用域(1:系统级（全局） 2:租户级 )
     */
    @TableField("scope")
    private Integer scope;

    /**
     * 项目名称
     */
    @TableField("project_name")
    private String projectName;

    /**
     * 项目编码(租户内唯一)
     */
    @TableField("project_code")
    private String projectCode;

    /**
     * 项目描述
     */
    @TableField("description")
    private String description;

    /**
     * 状态(0:禁用 1:启用)
     */
    @TableField("status")
    private Integer status;

    /**
     * 项目开始时间
     */
    @TableField("start_time")
    private LocalDateTime startTime;

    /**
     * 项目结束时间
     */
    @TableField("end_time")
    private LocalDateTime endTime;

    /**
     * 所属租户ID（业务id）
     */
    @TableField("tenant_biz_id")
    private String tenantBizId;

    /**
     * 是否内置项目（0-否 1-是 默认0-否 是内置项目，那么整个项目的所绑定的菜单权限都在中台系统展示内嵌外链iframe, 如果不是直接是访问项目卡片直接跳转到独立的前端项目链接获取权限菜单访问）
     */
    @TableField("is_in")
    private Integer isIn;

    /**
     * 项目图标地址
     */
    @TableField("logo_url")
    private String logoUrl;

    /**
     * 项目访问地址
     */
    @TableField("project_url")
    private String projectUrl;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Boolean isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
