package com.yd.user.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.user.api.service.ApiClientUserService;
import com.yd.user.feign.client.clientuser.ApiClientUserFeignClient;
import com.yd.user.feign.request.clientuser.ApiClientUserDetailBodyRequest;
import com.yd.user.feign.request.clientuser.ApiClientUserEditApprovalStatusRequest;
import com.yd.user.feign.request.clientuser.ApiClientUserPageRequest;
import com.yd.user.feign.request.clientuser.ApiClientUserSaveRequest;
import com.yd.user.feign.response.clientuser.ApiClientUserDetailResponse;
import com.yd.user.feign.response.clientuser.ApiClientUserPageResponse;
import com.yd.user.feign.response.clientuser.ApiClientUserSaveResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 客户端用户信息
 *
 * @author zxm
 * @since 2025-10-20
 */
@RestController
@RequestMapping("/clientUser")
@Validated
public class ApiClientUserController implements ApiClientUserFeignClient {

    @Autowired
    private ApiClientUserService apiClientUserService;

    /**
     * 分页查询-客户端用户信息
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiClientUserPageResponse>> page(ApiClientUserPageRequest request) {
        return apiClientUserService.page(request);
    }

    /**
     * 详情-客户端用户信息
     * @param clientUserBizId
     * @return
     */
    @Override
    public Result<ApiClientUserDetailResponse> detail(String clientUserBizId) {
        return apiClientUserService.detail(clientUserBizId);
    }

    /**
     * 根据条件查询客户端用户业务ID列表
     * @param tenantBizId
     * @param tenantBizId
     * @return
     */
    @Override
    public Result<List<String>> clientUserBizIdList(String tenantBizId, String projectBizId) {
        return apiClientUserService.clientUserBizIdList(tenantBizId,projectBizId);
    }

    /**
     * 获取客户端用户详情 body入参
     * @return
     */
    @Override
    public Result<ApiClientUserDetailResponse> detail(ApiClientUserDetailBodyRequest request) {
        return apiClientUserService.detail(request);
    }

    /**
     * 保存客户端用户信息（新增或者编辑）
     * @return
     */
    @Override
    public Result<ApiClientUserSaveResponse> save(ApiClientUserSaveRequest request) {
        return apiClientUserService.save(request);
    }

    /**
     * 编辑-客户端用户审批状态
     * @return
     */
    @Override
    public Result editApprovalStatus(ApiClientUserEditApprovalStatusRequest request) {
        return apiClientUserService.editApprovalStatus(request);
    }

    /**
     * 编辑-客户端用户openId
     * @return
     */
    @Override
    public Result editOpenId(String clientUserBizId,String openId) {
        return apiClientUserService.editOpenId(clientUserBizId,openId);
    }

}
