package com.yd.user.feign.client.sysdept;

import com.yd.common.result.Result;
import com.yd.user.feign.request.sysdept.*;
import com.yd.user.feign.response.sysdept.ApiSysDeptDetailResponse;
import com.yd.user.feign.fallback.sysdept.ApiSysDeptFeignFallbackFactory;
import com.yd.user.feign.response.sysdept.ApiSysDeptTreeListResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 用户服务-部门项目信息Feign客户端
 */
@FeignClient(name = "yd-user-api", fallbackFactory = ApiSysDeptFeignFallbackFactory.class)
public interface ApiSysDeptFeignClient {

    /**
     * 树形部门列表查询
     * @param request
     * @return
     */
    @PostMapping("/tree/list")
    Result<List<ApiSysDeptTreeListResponse>> treeList(@RequestBody ApiSysDeptTreeListRequest request);

    /**
     * 部门分页查询
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiSysDeptPageRequest request);

    /**
     * 公司分页查询（公司类型）
     * @param request
     * @return
     */
    @PostMapping("/company/page")
    Result companyPage(@RequestBody ApiSysDeptCompanyPageRequest request);

    /**
     * 获取部门详情
     * @param deptBizId 部门唯一标识(业务ID)
     * @return
     */
    @GetMapping("/detail")
    Result<ApiSysDeptDetailResponse> detail(@NotBlank(message = "部门唯一标识(业务ID)不能为空") @RequestParam(value = "deptBizId") String deptBizId);

    /**
     * 添加部门
     * @param request
     * @return
     */
    @PostMapping("/add")
    Result add(@Validated @RequestBody ApiSysDeptAddRequest request);

    /**
     * 编辑部门
     * @param request
     * @return
     */
    @PutMapping("/edit")
    Result edit(@Validated @RequestBody ApiSysDeptEditRequest request);


    /**
     * 删除部门（逻辑删除）
     * @param deptBizId 部门唯一标识(业务ID)
     * @return
     */
    @DeleteMapping("/del")
    Result del(@NotBlank(message = "部门唯一标识(业务ID)不能为空") @RequestParam(value = "deptBizId") String deptBizId);

    /**
     * 编辑部门状态
     * @param deptBizId 部门唯一标识(业务ID)
     * @param status 状态(0:禁用 1:启用)
     * @return
     */
    @PatchMapping("/edit/status")
    Result editStatus(@NotBlank(message = "部门唯一标识(业务ID)不能为空") @RequestParam(value = "deptBizId") String deptBizId,
                      @NotNull(message = "状态不能为空") @RequestParam(value = "status") Integer status);
}
