package com.yd.user.feign.request.reltenantmenu;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * 添加租户和菜单列表关系入参
 */
@Data
public class ApiRelTenantMenuListAddRequest {

    /**
     * 租户唯一标识(业务ID)
     */
    @NotBlank(message = "租户唯一标识(业务ID)不能为空")
    private String tenantBizId;

    /**
     * 菜单唯一标识(业务ID) 列表（选中列表）
     */
    @NotEmpty(message = "菜单唯一标识(业务ID) 列表（选中列表）不能为空")
    private List<String> menuBizIdList;
}
