package com.yd.user.service.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.user.feign.request.relprojectrole.ApiRelProjectRoleListPageRequest;
import com.yd.user.feign.request.relprojectrole.ApiRelProjectRoleSelectPageRequest;
import com.yd.user.feign.request.reltenantrole.ApiRelTenantRoleListPageRequest;
import com.yd.user.feign.request.reltenantrole.ApiRelTenantRoleSelectPageRequest;
import com.yd.user.feign.response.relprojectrole.ApiRelProjectRoleListPageResponse;
import com.yd.user.feign.response.relprojectrole.ApiRelProjectRoleSelectPageResponse;
import com.yd.user.feign.response.reltenantrole.ApiRelTenantRoleListPageResponse;
import com.yd.user.feign.response.reltenantrole.ApiRelTenantRoleSelectPageResponse;
import com.yd.user.service.model.RelProjectRole;
import org.apache.ibatis.annotations.Param;

/**
 * <p>
 * 项目-角色关系表（正常来说一对多，加关系表方便扩展） Mapper 接口
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
public interface RelProjectRoleMapper extends BaseMapper<RelProjectRole> {

    IPage<ApiRelProjectRoleListPageResponse> page(@Param("page") IPage<ApiRelProjectRoleListPageResponse> page,
                                                  @Param("request") ApiRelProjectRoleListPageRequest request);

    /**
     * 导入-选择角色分页查询（查询当前项目级（当前所属项目绑定的角色）或者系统级（全局角色在任何地方都适用导入绑定）的角色表数据）
     * @param page
     * @param request
     * @return
     */
    IPage<ApiRelProjectRoleSelectPageResponse> selectProjectPage(@Param("page") IPage<ApiRelProjectRoleSelectPageResponse> page,
                                                                 @Param("request") ApiRelProjectRoleSelectPageRequest request);
}
