package com.yd.user.service.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.user.feign.request.reluserrole.ApiCandidateProjectUserRolePageRequest;
import com.yd.user.feign.request.reluserrole.ApiCandidateTenantUserRolePageRequest;
import com.yd.user.feign.request.reluserrole.ApiSelectedProjectUserRolePageRequest;
import com.yd.user.feign.request.reluserrole.ApiSelectedTenantUserRolePageRequest;
import com.yd.user.feign.response.reluserrole.ApiCandidateProjectUserRolePageResponse;
import com.yd.user.feign.response.reluserrole.ApiCandidateTenantUserRolePageResponse;
import com.yd.user.feign.response.reluserrole.ApiSelectedProjectUserRolePageResponse;
import com.yd.user.feign.response.reluserrole.ApiSelectedTenantUserRolePageResponse;
import com.yd.user.service.model.RelUserRole;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 用户-角色关系表（多对多关系） Mapper 接口
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
public interface RelUserRoleMapper extends BaseMapper<RelUserRole> {

    IPage<ApiCandidateTenantUserRolePageResponse> candidateTenantUserRolePage(@Param("page") Page<ApiCandidateTenantUserRolePageResponse> page,
                                                                              @Param("request") ApiCandidateTenantUserRolePageRequest request);

    IPage<ApiSelectedTenantUserRolePageResponse> selectedTenantUserRolePage(@Param("page") Page<ApiSelectedTenantUserRolePageResponse> page,
                                                                            @Param("request") ApiSelectedTenantUserRolePageRequest request);

    IPage<ApiCandidateProjectUserRolePageResponse> candidateProjectUserRolePage(@Param("page") Page<ApiCandidateProjectUserRolePageResponse> page,
                                                                                @Param("request") ApiCandidateProjectUserRolePageRequest request);

    IPage<ApiSelectedProjectUserRolePageResponse> selectedProjectUserRolePage(@Param("page") Page<ApiSelectedProjectUserRolePageResponse> page,
                                                                              @Param("request") ApiSelectedProjectUserRolePageRequest request);
}
