package com.yd.user.service.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.user.feign.request.sysmenu.ApiSysMenuPageRequest;
import com.yd.user.feign.response.sysmenu.ApiSysMenuPageResponse;
import com.yd.user.feign.response.sysmenu.ApiSysMenuTreeListResponse;
import com.yd.user.service.dto.SysMenuDto;
import com.yd.user.service.dto.SysRoleDto;
import com.yd.user.service.model.SysMenu;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yd.user.service.model.SysRole;

import java.util.List;

/**
 * <p>
 * 菜单权限表 服务类
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
public interface ISysMenuService extends IService<SysMenu> {

    SysMenu queryOne(String menuBizId);

    List<SysMenu> queryList(SysMenuDto dto);

    List<SysMenu> queryAll();

    List<ApiSysMenuTreeListResponse> treeList(String loginTenantBizId,
                                              Boolean isAdmin,
                                              String menuName,
                                              List<String> projectBizIdList);

    IPage<ApiSysMenuPageResponse> page(Page<ApiSysMenuPageResponse> page,
                                       ApiSysMenuPageRequest request,
                                       Boolean isAdmin,
                                       List<String> projectBizIdList,
                                       String loginTenantBizId);
}
