package com.yd.user.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 国庆地区基础表
 * @TableName md_country
 */
@TableName(value ="md_country")
@Data
public class MdCountry implements Serializable {
    /**
     * 
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 唯一标识(业务ID)
     */
    private String countryBizId;

    /**
     * 国家名称
     */
    private String name;

    /**
     * 国家代码
     */
    private String countryCode;

    /**
     * 联系电话
     */
    private String group;

    /**
     * 地区代码
     */
    private String areaCode;

    /**
     * 热门排名
     */
    private Integer hotRank;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}