package com.yd.user.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.user.feign.request.relprojectuser.ApiRelProjectUserListPageRequest;
import com.yd.user.feign.request.relprojectuser.ApiRelProjectUserSelectPageRequest;
import com.yd.user.feign.response.relprojectuser.ApiRelProjectUserListPageResponse;
import com.yd.user.feign.response.relprojectuser.ApiRelProjectUserSelectPageResponse;
import com.yd.user.service.dto.RelProjectUserDto;
import com.yd.user.service.model.RelProjectUser;
import com.yd.user.service.dao.RelProjectUserMapper;
import com.yd.user.service.model.RelRoleMenu;
import com.yd.user.service.service.IRelProjectUserService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 项目-用户关系表（多对多关系） 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
@Service
@Primary
public class RelProjectUserServiceImpl extends ServiceImpl<RelProjectUserMapper, RelProjectUser> implements IRelProjectUserService {

    /**
     * 项目和用户关系分页查询
     * @param request
     * @return
     */
    @Override
    public IPage<ApiRelProjectUserListPageResponse> page(Page<ApiRelProjectUserListPageResponse> page,
                                                         ApiRelProjectUserListPageRequest request) {
        return baseMapper.page(page,request);
    }

    /**
     * 导入-选择用户分页查询（查询用户库的用户id不在当前项目用户关系的用户id列表中的数据）
     * @param request
     * @return
     */
    @Override
    public IPage<ApiRelProjectUserSelectPageResponse> selectUserPage(Page<ApiRelProjectUserSelectPageResponse> page, ApiRelProjectUserSelectPageRequest request) {
        return baseMapper.selectUserPage(page,request);
    }

    /**
     * 查询单个对象
     * @param id
     * @return
     */
    @Override
    public RelProjectUser queryOne(Long id) {
        return this.getById(id);
    }

    /**
     * 查询关系列表
     * @param dto
     * @return
     */
    @Override
    public List<RelProjectUser> queryList(RelProjectUserDto dto) {
        List<RelProjectUser> list = baseMapper.selectList(new LambdaQueryWrapper<RelProjectUser>()
                .eq(StringUtils.isNotBlank(dto.getProjectBizId()),RelProjectUser::getProjectBizId,dto.getProjectBizId())
                .eq(StringUtils.isNotBlank(dto.getUserBizId()),RelProjectUser::getUserBizId,dto.getUserBizId())
        );
        return list;
    }
}
