package com.yd.user.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.user.service.dto.RelRoleMenuDto;
import com.yd.user.service.model.RelRoleMenu;
import com.yd.user.service.dao.RelRoleMenuMapper;
import com.yd.user.service.model.RelTenantUser;
import com.yd.user.service.service.IRelRoleMenuService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 角色-菜单关系表（多对多关系） 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
@Service
@Primary
public class RelRoleMenuServiceImpl extends ServiceImpl<RelRoleMenuMapper, RelRoleMenu> implements IRelRoleMenuService {

    /**
     * 根据条件查询角色菜单列表
     * @param dto
     * @return
     */
    @Override
    public List<RelRoleMenu> queryList(RelRoleMenuDto dto) {
        List<RelRoleMenu> list = baseMapper.selectList(new LambdaQueryWrapper<RelRoleMenu>()
                .eq(!Objects.isNull(dto.getId()),RelRoleMenu::getId,dto.getId())
                .eq(StringUtils.isNotBlank(dto.getTenantBizId()),RelRoleMenu::getTenantBizId,dto.getTenantBizId())
                .eq(StringUtils.isNotBlank(dto.getProjectBizId()),RelRoleMenu::getProjectBizId,dto.getProjectBizId())
                .eq(StringUtils.isNotBlank(dto.getRoleBizId()),RelRoleMenu::getRoleBizId,dto.getRoleBizId())
                .eq(StringUtils.isNotBlank(dto.getMenuBizId()),RelRoleMenu::getMenuBizId,dto.getMenuBizId())
                .in(!CollectionUtils.isEmpty(dto.getRoleBizIdList()),RelRoleMenu::getRoleBizId,dto.getRoleBizIdList())
        );
        return list;
    }

    @Override
    public Boolean removeByTenant(String tenantBizId, String roleBizId) {
        return this.remove(new LambdaQueryWrapper<RelRoleMenu>()
                .eq(RelRoleMenu::getTenantBizId,tenantBizId)
                .eq(RelRoleMenu::getRoleBizId,roleBizId)
        );
    }

    @Override
    public Boolean removeByProject(String projectBizId, String roleBizId) {
        return this.remove(new LambdaQueryWrapper<RelRoleMenu>()
                .eq(RelRoleMenu::getProjectBizId,projectBizId)
                .eq(RelRoleMenu::getRoleBizId,roleBizId)
        );
    }
}
