package com.yd.user.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.user.feign.request.sysdict.ApiUpdateRedisDictListRequest;
import com.yd.user.feign.response.sysdict.ApiUpdateRedisDictListResponse;
import com.yd.user.feign.response.sysdict.GetDictItemListByDictTypeResponse;
import com.yd.user.service.model.SysDict;
import com.yd.user.service.dao.SysDictMapper;
import com.yd.user.service.model.SysDictItem;
import com.yd.user.service.service.ISysDictService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 字典类型表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
@Service
@Primary
public class SysDictServiceImpl extends ServiceImpl<SysDictMapper, SysDict> implements ISysDictService {

    /**
     * 根据字典类型查询单个对象
     * @param dictType
     * @return
     */
    @Override
    public SysDict queryOneByType(String dictType) {
        return this.getOne(new LambdaQueryWrapper<SysDict>().eq(SysDict::getDictType,dictType));
    }

    /**
     * 查询列表
     * @param dictTypeList
     * @return
     */
    @Override
    public List<SysDict> queryList(List<String> dictTypeList) {
        List<SysDict> list = baseMapper.selectList(new LambdaQueryWrapper<SysDict>()
                .in(!CollectionUtils.isEmpty(dictTypeList),SysDict::getDictType,dictTypeList)
        );
        return list;
    }

    @Override
    public List<GetDictItemListByDictTypeResponse> queryListByTypeList(List<String> typeList) {
        return baseMapper.queryListByTypeList(typeList);
    }
}
