package com.yd.user.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.user.api.service.ApiSysTenantService;
import com.yd.user.feign.client.systenant.ApiSysTenantFeignClient;
import com.yd.user.feign.request.systenant.ApiSysTenantAddRequest;
import com.yd.user.feign.request.systenant.ApiSysTenantEditRequest;
import com.yd.user.feign.request.systenant.ApiSysTenantPageRequest;
import com.yd.user.feign.response.systenant.ApiSysTenantDetailResponse;
import com.yd.user.feign.response.systenant.ApiSysTenantPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 租户信息
 *
 * @author zxm
 * @since 2025-07-31
 */
@RestController
@RequestMapping("/sysTenant")
@Validated
public class ApiSysTenantController implements ApiSysTenantFeignClient {

    @Autowired
    private ApiSysTenantService apiSysTenantService;

    /**
     * 租户分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiSysTenantPageResponse>> page(ApiSysTenantPageRequest request) {
        return apiSysTenantService.page(request);
    }

    /**
     * 获取租户详情
     * @param tenantUid 租户唯一标识(业务ID)
     * @return
     */
    @Override
    public Result<ApiSysTenantDetailResponse> detail(String tenantUid) {
        return apiSysTenantService.detail(tenantUid);
    }

    /**
     * 添加租户
     * @param request
     * @return
     */
    @Override
    public Result add(ApiSysTenantAddRequest request) {
        return apiSysTenantService.add(request);
    }

    /**
     * 编辑租户
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiSysTenantEditRequest request) {
        return apiSysTenantService.edit(request);
    }

    /**
     * 删除租户（逻辑删除）
     * @param tenantUid 租户唯一标识(业务ID)
     * @return
     */
    @Override
    public Result del(String tenantUid) {
        return null;
    }

    /**
     * 编辑租户状态
     * @param tenantUid 租户唯一标识(业务ID)
     * @param status 状态(0:禁用 1:启用)
     * @return
     */
    @Override
    public Result editStatus(String tenantUid, Integer status) {
        return null;
    }
}
