package com.yd.user.service.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class SysRoleDto {

    /**
     * 主键id
     */
    private Long id;

    /**
     * 角色唯一标识(业务ID)
     */
    private String roleBizId;

    /**
     * 角色唯一标识(业务ID)集合
     */
    private List<String> roleBizIdList;

    /**
     * 角色名称
     */
    private String roleName;

    /**
     * 查询是否排除当前角色唯一标识数据，默认false不排除，true的话roleBizId必传
     */
    @Builder.Default
    private Boolean isExcludeMy = false;
}
