package com.yd.user.feign.fallback.sysmenu;

import com.yd.common.result.Result;
import com.yd.user.feign.client.sysmenu.ApiSysMenuFeignClient;
import com.yd.user.feign.request.sysmenu.ApiSysMenuAddRequest;
import com.yd.user.feign.request.sysmenu.ApiSysMenuEditRequest;
import com.yd.user.feign.request.sysmenu.ApiSysMenuPageRequest;
import com.yd.user.feign.request.sysmenu.ApiSysMenuTreeListRequest;
import com.yd.user.feign.response.sysmenu.ApiSysMenuDetailResponse;
import com.yd.user.feign.response.sysmenu.ApiSysMenuTreeListResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 用户服务：菜单关系信息Feign降级处理
 */
@Slf4j
@Component
public class ApiSysMenuFeignFallbackFactory implements FallbackFactory<ApiSysMenuFeignClient> {
    @Override
    public ApiSysMenuFeignClient create(Throwable cause) {
        return new ApiSysMenuFeignClient() {
            @Override
            public Result<List<ApiSysMenuTreeListResponse>> treeList(ApiSysMenuTreeListRequest request) {
                return null;
            }

            @Override
            public Result page(ApiSysMenuPageRequest request) {
                return null;
            }

            @Override
            public Result<ApiSysMenuDetailResponse> detail(String menuBizId) {
                return null;
            }

            @Override
            public Result add(ApiSysMenuAddRequest request) {
                return null;
            }

            @Override
            public Result edit(ApiSysMenuEditRequest request) {
                return null;
            }

            @Override
            public Result del(String menuBizId) {
                return null;
            }

            @Override
            public Result editStatus(String menuBizId,Integer status) {
                return null;
            }
        };
    }
}
