package com.yd.user.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.user.api.service.ApiSysMenuService;
import com.yd.user.feign.client.sysmenu.ApiSysMenuFeignClient;
import com.yd.user.feign.request.sysmenu.ApiSysMenuAddRequest;
import com.yd.user.feign.request.sysmenu.ApiSysMenuEditRequest;
import com.yd.user.feign.request.sysmenu.ApiSysMenuPageRequest;
import com.yd.user.feign.request.sysmenu.ApiSysMenuTreeListRequest;
import com.yd.user.feign.response.sysmenu.ApiSysMenuDetailResponse;
import com.yd.user.feign.response.sysmenu.ApiSysMenuPageResponse;
import com.yd.user.feign.response.sysmenu.ApiSysMenuTreeListResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 菜单信息
 *
 * @author zxm
 * @since 2025-07-31
 */
@RestController
@RequestMapping("/sysMenu")
@Validated
public class ApiSysMenuController implements ApiSysMenuFeignClient {

    @Autowired
    private ApiSysMenuService apiSysMenuService;

    /**
     * 树形菜单列表查询
     * @param request
     * @return
     */
    @Override
    public Result<List<ApiSysMenuTreeListResponse>> treeList(ApiSysMenuTreeListRequest request) {
        return apiSysMenuService.treeList(request);
    }

    /**
     * 菜单分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiSysMenuPageResponse>> page(ApiSysMenuPageRequest request) {
        return apiSysMenuService.page(request);
    }

    /**
     * 获取菜单详情
     * @param menuBizId 菜单唯一标识(业务ID)
     * @return
     */
    @Override
    public Result<ApiSysMenuDetailResponse> detail(String menuBizId) {
        return apiSysMenuService.detail(menuBizId);
    }

    /**
     * 添加菜单
     * @param request
     * @return
     */
    @Override
    public Result add(ApiSysMenuAddRequest request) {
        return apiSysMenuService.add(request);
    }

    /**
     * 编辑菜单
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiSysMenuEditRequest request) {
        return apiSysMenuService.edit(request);
    }

    /**
     * 删除菜单（逻辑删除） TODO
     * @param menuBizId 菜单唯一标识(业务ID)
     * @return
     */
    @Override
    public Result del(String menuBizId) {
        return apiSysMenuService.del(menuBizId);
    }

    /**
     * 编辑菜单状态 TODO
     * @param menuBizId 菜单唯一标识(业务ID)
     * @param status 状态(0:禁用 1:启用)
     * @return
     */
    @Override
    public Result editStatus(String menuBizId,Integer status) {
        return apiSysMenuService.editStatus(menuBizId,status);
    }
}
