package com.yd.user.api.dto;

import lombok.Data;


/**
 * 菜单添加和编辑校验入参的DTO
 */
@Data
public class ApiSysMenuAddAndEditReqCheckDto {

    /**
     * 菜单id
     */
    private String menuBizId;

    /**
     * 父菜单ID
     */
    private String parentBizId;

    /**
     * 类型(1:目录 2:菜单 3:按钮)
     */
    private Integer menuType;

    /**
     * 路由地址
     */
    private String path;

    /**
     * 作用域(1:系统级（全局） 2:租户级 3:项目级)
     */
    private Integer scope;

    /**
     * 所属租户ID（业务id）
     */
    private String tenantBizId;

    /**
     * 所属项目ID（业务id）
     */
    private String projectBizId;

    /**
     * 是否是超级管理员
     */
    private Boolean isAdmin;

    /**
     * 操作来源 1-添加 2-编辑
     */
    private String oprSource;
}
