package com.yd.user.feign.fallback.reltenantmenu;

import com.yd.common.result.Result;
import com.yd.user.feign.client.reltenantmenu.ApiRelTenantMenuFeignClient;
import com.yd.user.feign.request.reltenantmenu.ApiRelTenantMenuListAddRequest;
import com.yd.user.feign.request.reltenantmenu.ApiRelTenantMenuListPageRequest;
import com.yd.user.feign.request.reltenantmenu.ApiRelTenantMenuImportQueryMenuTreeRequest;
import com.yd.user.feign.request.reltenantmenu.ApiRelTenantMenuTreeListRequest;
import com.yd.user.feign.response.reltenantmenu.ApiRelTenantMenuImportQueryMenuTreeResponse;
import com.yd.user.feign.response.reltenantmenu.ApiRelTenantMenuTreeListResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 用户服务：租户-菜单关系信息Feign降级处理
 */
@Slf4j
@Component
public class ApiRelTenantMenuFeignFallbackFactory implements FallbackFactory<ApiRelTenantMenuFeignClient> {
    @Override
    public ApiRelTenantMenuFeignClient create(Throwable cause) {
        return new ApiRelTenantMenuFeignClient() {
            @Override
            public Result page(ApiRelTenantMenuListPageRequest request) {
                return null;
            }

            @Override
            public Result<List<ApiRelTenantMenuTreeListResponse>> tree(ApiRelTenantMenuTreeListRequest request) {
                return null;
            }

            @Override
            public Result addMenuList(ApiRelTenantMenuListAddRequest request) {
                return null;
            }

            @Override
            public Result del(Long id) {
                return null;
            }

            @Override
            public Result<List<ApiRelTenantMenuImportQueryMenuTreeResponse>> importQueryMenuTree(ApiRelTenantMenuImportQueryMenuTreeRequest request) {
                return null;
            }

            @Override
            public Result<List<String>> selectedList(String tenantBizId) {
                return null;
            }

        };
    }
}
