package com.yd.user.feign.request.clientuser;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.util.List;

@Data
public class ApiClientUserSaveRequest {

    /**
     * 客户端用户表唯一业务ID 有值做编辑，无值做新增
     */
    private String clientUserBizId;

    /**
     * 头像
     */
    private String avatar;

    /**
     * 姓名
     */
    @NotBlank(message = "姓名不能为空")
    private String name;

    /**
     * 手机号
     */
    @NotBlank(message = "手机号不能为空")
    @Pattern(regexp = "^(?:(?:\\+|00)86)?1[3-9]\\d{9}$", message = "手机号格式不正确")
    private String phone;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 证件类型
     */
    @NotBlank(message = "证件类型不能为空")
    private String idCardType;

    /**
     * 证件号码
     */
    @NotBlank(message = "证件号码不能为空")
    private String idCardNumber;

    /**
     * 证件文件url列表
     */
    @NotEmpty(message = "证件文件url列表不能为空")
    private List<String> idCardFileUrlList;

    /**
     * 银行卡号
     */
    @NotBlank(message = "银行卡号不能为空")
    private String bankNumber;

    /**
     * 开户行
     */
    @NotBlank(message = "开户行不能为空")
    private String openBank;

    /**
     * 银行卡文件url列表
     */
    @NotEmpty(message = "银行卡文件url列表不能为空")
    private List<String> bankFileUrlList;

    /**
     * 登录密码
     */
    private String password;

    /**
     * 客户端用户邀请码
     */
    private String invitationCode;

    /**
     * 状态(0:停用 1:启用)
     */
    @NotNull(message = "状态不能为空")
    private Integer status;

    /**
     * 审批状态
     */
    @NotBlank(message = "审批状态不能为空")
    private String approvalStatus;

    /**
     * 注册来源（PC、小程序等）默认小程序 - MINI_PROGRAM
     */
    @NotBlank(message = "注册来源不能为空")
    private String registerSource;

    /**
     * 所属租户唯一业务ID（冗余）
     */
    @NotBlank(message = "所属租户唯一业务ID不能为空")
    private String tenantBizId;

    /**
     * 所属项目唯一业务ID（冗余）
     */
    @NotBlank(message = "所属项目唯一业务ID不能为空")
    private String projectBizId;

    /**
     * 小程序的openId
     */
    private String openId;

}
