package com.yd.user.feign.fallback.sysdept;

import com.yd.common.result.Result;
import com.yd.user.feign.client.sysdept.ApiSysDeptFeignClient;
import com.yd.user.feign.request.sysdept.*;
import com.yd.user.feign.response.sysdept.ApiSysDeptDetailResponse;
import com.yd.user.feign.response.sysdept.ApiSysDeptTreeListResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 用户服务-部门信息Feign降级处理
 */
@Slf4j
@Component
public class ApiSysDeptFeignFallbackFactory implements FallbackFactory<ApiSysDeptFeignClient> {
    @Override
    public ApiSysDeptFeignClient create(Throwable cause) {
        return new ApiSysDeptFeignClient() {
            @Override
            public Result<List<ApiSysDeptTreeListResponse>> treeList(ApiSysDeptTreeListRequest request) {
                return null;
            }

            @Override
            public Result page(ApiSysDeptPageRequest request) {
                return null;
            }

            @Override
            public Result companyPage(ApiSysDeptCompanyPageRequest request) {
                return null;
            }

            @Override
            public Result<ApiSysDeptDetailResponse> detail(@NotBlank(message = "部门唯一标识(业务ID)不能为空") String deptBizId) {
                return null;
            }

            @Override
            public Result add(ApiSysDeptAddRequest request) {
                return null;
            }

            @Override
            public Result edit(ApiSysDeptEditRequest request) {
                return null;
            }

            @Override
            public Result del(@NotBlank(message = "部门唯一标识(业务ID)不能为空") String deptBizId) {
                return null;
            }

            @Override
            public Result editStatus(@NotBlank(message = "部门唯一标识(业务ID)不能为空") String deptBizId, @NotNull(message = "状态不能为空") Integer status) {
                return null;
            }
        };
    }
}
