package com.yd.user.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.user.api.service.ApiRelProjectMenuService;
import com.yd.user.feign.client.relprojectmenu.ApiRelProjectMenuFeignClient;
import com.yd.user.feign.request.relprojectmenu.ApiRelProjectMenuImportQueryMenuTreeRequest;
import com.yd.user.feign.request.relprojectmenu.ApiRelProjectMenuListAddRequest;
import com.yd.user.feign.request.relprojectmenu.ApiRelProjectMenuListPageRequest;
import com.yd.user.feign.request.relprojectmenu.ApiRelProjectMenuTreeListRequest;
import com.yd.user.feign.response.relprojectmenu.ApiRelProjectMenuImportQueryMenuTreeResponse;
import com.yd.user.feign.response.relprojectmenu.ApiRelProjectMenuListPageResponse;
import com.yd.user.feign.response.relprojectmenu.ApiRelProjectMenuTreeListResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import java.util.List;

/**
 * 项目-菜单关系信息（项目管理-菜单配置）
 *
 * @author zxm
 * @since 2025-07-31
 */
@RestController
@RequestMapping("/relProjectMenu")
@Validated
public class ApiRelProjectMenuController implements ApiRelProjectMenuFeignClient {

    @Autowired
    private ApiRelProjectMenuService apiRelProjectMenuService;

    /**
     * 项目和菜单关系分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiRelProjectMenuListPageResponse>> page(ApiRelProjectMenuListPageRequest request) {
        return apiRelProjectMenuService.page(request);
    }

    /**
     * 项目和菜单关系树形列表查询
     * @param request
     * @return
     */
    @Override
    public Result<List<ApiRelProjectMenuTreeListResponse>> tree(ApiRelProjectMenuTreeListRequest request) {
        return apiRelProjectMenuService.tree(request);
    }

    /**
     * 添加项目和菜单列表关系
     * @param request
     * @return
     */
    @Override
    public Result addMenuList(ApiRelProjectMenuListAddRequest request) {
        return apiRelProjectMenuService.addMenuList(request);
    }

    /**
     * 删除项目和菜单关系
     * @param id 项目和菜单关系表主键id
     * @return
     */
    @Override
    public Result del(Long id) {
        return apiRelProjectMenuService.del(id);
    }

    /**
     * 导入-树形菜单查询
     * @param request
     * @return
     */
    @Override
    public Result<List<ApiRelProjectMenuImportQueryMenuTreeResponse>> importQueryMenuTree(ApiRelProjectMenuImportQueryMenuTreeRequest request) {

        return apiRelProjectMenuService.importQueryMenuTree(request);
    }

    /**
     * 导入-树形菜单-查询选中的菜单id集合
     * @param projectBizId
     * @return
     */
    @Override
    public Result<List<String>> selectedList(String projectBizId) {
        return apiRelProjectMenuService.selectedList(projectBizId);
    }
}
