package com.yd.user.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.user.api.service.ApiRelTenantMenuService;
import com.yd.user.feign.client.reltenantmenu.ApiRelTenantMenuFeignClient;
import com.yd.user.feign.request.reltenantmenu.ApiRelTenantMenuListAddRequest;
import com.yd.user.feign.request.reltenantmenu.ApiRelTenantMenuListPageRequest;
import com.yd.user.feign.request.reltenantmenu.ApiRelTenantMenuSelectPageRequest;
import com.yd.user.feign.response.reltenantmenu.ApiRelTenantMenuListPageResponse;
import com.yd.user.feign.response.reltenantmenu.ApiRelTenantMenuSelectPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotNull;

/**
 * 租户-菜单关系信息（租户管理-菜单配置）
 *
 * @author zxm
 * @since 2025-07-31
 */
@RestController
@RequestMapping("/relTenantMenu")
@Validated
public class ApiRelTenantMenuController implements ApiRelTenantMenuFeignClient {

    @Autowired
    private ApiRelTenantMenuService apiRelTenantMenuService;

    /**
     * 租户和菜单关系分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiRelTenantMenuListPageResponse>> page(ApiRelTenantMenuListPageRequest request) {
        return apiRelTenantMenuService.page(request);
    }

    /**
     * 添加租户和菜单列表关系
     * @param request
     * @return
     */
    @Override
    public Result addMenuList(ApiRelTenantMenuListAddRequest request) {
        return apiRelTenantMenuService.addMenuList(request);
    }

    /**
     * 删除租户和菜单关系
     * @param id 租户和菜单关系表主键id
     * @return
     */
    @Override
    public Result del(Long id) {
        return apiRelTenantMenuService.del(id);
    }

    /**
     * 导入-选择菜单分页查询（查询当前租户级（当前所属租户绑定的菜单）或者系统级（全局菜单在任何地方都适用导入绑定）的菜单表数据）
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiRelTenantMenuSelectPageResponse>> selectMenuPage(ApiRelTenantMenuSelectPageRequest request) {
        return apiRelTenantMenuService.selectMenuPage(request);
    }
}
