package com.yd.user.api.service.impl;

import com.yd.common.result.Result;
import com.yd.user.api.service.ApiRelProjectMenuService;
import com.yd.user.service.model.RelProjectMenu;
import com.yd.user.service.service.IRelProjectMenuService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiRelProjectMenuServiceImpl implements ApiRelProjectMenuService {

    @Autowired
    private IRelProjectMenuService iRelProjectMenuService;

    /**
     * 添加单个项目和菜单关系
     * @param projectBizId
     * @param menuBizId
     * @return
     */
    @Override
    public Result addSingleRel(String projectBizId, String menuBizId) {
        //新增关系
        RelProjectMenu relProjectMenu = new RelProjectMenu();
        relProjectMenu.setProjectBizId(projectBizId);
        relProjectMenu.setMenuBizId(menuBizId);
        iRelProjectMenuService.saveOrUpdate(relProjectMenu);
        return Result.success();
    }
}
