package com.yd.user.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.common.enums.ResultCode;
import com.yd.common.exception.BusinessException;
import com.yd.common.result.Result;
import com.yd.user.api.service.ApiRelTenantMenuService;
import com.yd.user.feign.request.reltenantmenu.ApiRelTenantMenuListAddRequest;
import com.yd.user.feign.request.reltenantmenu.ApiRelTenantMenuListPageRequest;
import com.yd.user.feign.request.reltenantmenu.ApiRelTenantMenuSelectPageRequest;
import com.yd.user.feign.response.reltenantmenu.ApiRelTenantMenuListPageResponse;
import com.yd.user.feign.response.reltenantmenu.ApiRelTenantMenuSelectPageResponse;
import com.yd.user.service.model.RelTenantMenu;
import com.yd.user.service.service.IRelTenantMenuService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Service
public class ApiRelTenantMenuServiceImpl implements ApiRelTenantMenuService {

    @Autowired
    private IRelTenantMenuService iRelTenantMenuService;

    /**
     * 租户和菜单关系分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiRelTenantMenuListPageResponse>> page(ApiRelTenantMenuListPageRequest request) {
        Page<ApiRelTenantMenuListPageResponse> page = new Page<>(request.getPageNo(), request.getPageSize());
        IPage<ApiRelTenantMenuListPageResponse> iPage = iRelTenantMenuService.page(page, request);
        return Result.success(iPage);
    }

    /**
     * 添加租户和菜单列表关系
     * @param request
     * @return
     */
    @Override
    public Result addMenuList(ApiRelTenantMenuListAddRequest request) {
        List<RelTenantMenu> list = new ArrayList<>();
        if (CollectionUtils.isEmpty(request.getMenuBizIdList())) {
            //菜单唯一标识(业务ID) 列表（选中列表）不为空
            list = request.getMenuBizIdList().stream().map(bizId -> {
                RelTenantMenu relTenantMenu = new RelTenantMenu();
                relTenantMenu.setTenantBizId(request.getTenantBizId());
                relTenantMenu.setMenuBizId(bizId);
                return relTenantMenu;
            }).collect(Collectors.toList());

            iRelTenantMenuService.saveOrUpdateBatch(list);
        }

        return Result.success();
    }

    /**
     * 删除租户和菜单关系
     * @param id 租户和菜单关系表主键id
     * @return
     */
    @Override
    public Result del(Long id) {
        RelTenantMenu relTenantMenu = iRelTenantMenuService.queryOne(id);
        if (Objects.isNull(relTenantMenu)) {
            //数据不存在
            throw new BusinessException(ResultCode.NULL_ERROR.getCode(),ResultCode.NULL_ERROR.getMessage());
        }
        iRelTenantMenuService.removeById(relTenantMenu.getId());
        return Result.success();
    }

    /**
     * 导入-选择菜单分页查询（查询当前租户级（当前所属租户绑定的菜单）或者系统级（全局菜单在任何地方都适用导入绑定）的菜单表数据）
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiRelTenantMenuSelectPageResponse>> selectMenuPage(ApiRelTenantMenuSelectPageRequest request) {
        Page<ApiRelTenantMenuSelectPageResponse> page = new Page<>(request.getPageNo(), request.getPageSize());
        IPage<ApiRelTenantMenuSelectPageResponse> iPage = iRelTenantMenuService.selectProjectPage(page, request);
        return Result.success(iPage);
    }

    /**
     * 添加单个租户和菜单关系
     * @param tenantBizId
     * @param menuBizId
     * @return
     */
    @Override
    public Result addSingleRel(String tenantBizId, String menuBizId) {
        //新增关系
        RelTenantMenu relTenantMenu = new RelTenantMenu();
        relTenantMenu.setTenantBizId(tenantBizId);
        relTenantMenu.setMenuBizId(menuBizId);
        iRelTenantMenuService.saveOrUpdate(relTenantMenu);
        return Result.success();
    }
}
