package com.yd.user.api.service.impl;

import com.yd.common.result.Result;
import com.yd.user.api.service.ApiRelUserRoleService;
import com.yd.user.feign.request.reluserrole.ApiProjectUserRoleListAddRequest;
import com.yd.user.feign.request.reluserrole.ApiTenantUserRoleListAddRequest;
import com.yd.user.feign.response.reluserrole.ApiSelectedProjectUserRoleListResponse;
import com.yd.user.feign.response.reluserrole.ApiSelectedTenantUserRoleListResponse;
import com.yd.user.service.model.RelUserRole;
import com.yd.user.service.service.IRelUserRoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class ApiRelUserRoleServiceImpl implements ApiRelUserRoleService {

    @Autowired
    private IRelUserRoleService iRelUserRoleService;

    /**
     * 租户管理-添加用户角色列表关系
     * @param request
     * @return
     */
    @Override
    public Result addTenantUserRoleList(ApiTenantUserRoleListAddRequest request) {
        //先删后新增关系
        //删除租户用户角色列表关系
        iRelUserRoleService.delRelTenantUserRole(request.getTenantBizId(),request.getUserBizId());

        //新增租户用户角色列表关系
        if (!CollectionUtils.isEmpty(request.getRoleBizIdList())) {
            List<RelUserRole> list = request.getRoleBizIdList().stream().map(bizId -> {
                RelUserRole relUserRole = new RelUserRole();
                relUserRole.setTenantBizId(request.getTenantBizId());
                relUserRole.setUserBizId(request.getUserBizId());
                relUserRole.setRoleBizId(bizId);
                return relUserRole;
            }).collect(Collectors.toList());

            iRelUserRoleService.saveOrUpdateBatch(list);
        }
        return Result.success();
    }

    /**
     * 租户管理-用户配置-权限配置-查询选中的角色列表
     * @return
     */
    @Override
    public Result<List<ApiSelectedTenantUserRoleListResponse>> selectedTenantUserRoleList(String tenantBizId, String userBizId) {
        List<ApiSelectedTenantUserRoleListResponse> list = iRelUserRoleService.selectedTenantUserRoleList(tenantBizId,userBizId);
        return Result.success(list);
    }

    /**
     * 项目管理-用户配置-权限配置-添加用户角色列表关系
     * @param request
     * @return
     */
    @Override
    public Result addProjectUserRoleList(ApiProjectUserRoleListAddRequest request) {
        //先删后新增关系
        //删除项目用户角色列表关系
        iRelUserRoleService.delRelProjectUserRole(request.getProjectBizId(),request.getUserBizId());

        //新增租户用户角色列表关系
        if (!CollectionUtils.isEmpty(request.getRoleBizIdList())) {
            List<RelUserRole> list = request.getRoleBizIdList().stream().map(bizId -> {
                RelUserRole relUserRole = new RelUserRole();
                relUserRole.setProjectBizId(request.getProjectBizId());
                relUserRole.setUserBizId(request.getUserBizId());
                relUserRole.setRoleBizId(bizId);
                return relUserRole;
            }).collect(Collectors.toList());

            iRelUserRoleService.saveOrUpdateBatch(list);
        }
        return Result.success();
    }

    /**
     * 项目管理-用户配置-权限配置-查询选中的角色列表
     * @return
     */
    @Override
    public Result<List<ApiSelectedProjectUserRoleListResponse>> selectedProjectUserRoleList(String projectBizId, String userBizId) {
        List<ApiSelectedProjectUserRoleListResponse> list = iRelUserRoleService.selectedProjectUserRoleList(projectBizId,userBizId);
        return Result.success(list);
    }

}
