package com.yd.user.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.common.enums.CommonEnum;
import com.yd.common.enums.ResultCode;
import com.yd.common.exception.BusinessException;
import com.yd.common.result.Result;
import com.yd.common.utils.RandomStringGenerator;
import com.yd.user.api.service.ApiRelTenantUserService;
import com.yd.user.api.service.ApiSysUserService;
import com.yd.user.feign.request.sysuser.ApiSysUserAddRequest;
import com.yd.user.feign.request.sysuser.ApiSysUserEditRequest;
import com.yd.user.feign.request.sysuser.ApiSysUserPageRequest;
import com.yd.user.feign.response.sysuser.ApiSysUserDetailResponse;
import com.yd.user.feign.response.sysuser.ApiSysUserPageResponse;
import com.yd.user.service.dto.SysUserDto;
import com.yd.user.service.model.SysTenant;
import com.yd.user.service.model.SysUser;
import com.yd.user.service.service.ISysUserService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;

@Service
public class ApiSysUserServiceImpl implements ApiSysUserService {

    @Autowired
    private ISysUserService iSysUserService;

    @Autowired
    private ApiRelTenantUserService apiRelTenantUserService;

    /**
     * 用户分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiSysUserPageResponse>> page(ApiSysUserPageRequest request) {
        //TODO 当前登录用户的角色类型 true是超级管理员 false是超级管理员
        Boolean isAdmin = false;
        //TODO 当前登录人所属租户id
        String loginTenantBizId = "";
        Page<ApiSysUserPageResponse> page = new Page<>(request.getPageNo(), request.getPageSize());
        IPage<ApiSysUserPageResponse> iPage = iSysUserService.page(page, request,isAdmin,loginTenantBizId);
        return Result.success(iPage);
    }

    /**
     * 添加用户
     * @param request
     * @return
     */
    @Override
    public Result add(ApiSysUserAddRequest request) {
        LocalDateTime now = LocalDateTime.now();
        //TODO 当前登录用户的角色类型 true是超级管理员 false是超级管理员
        Boolean isAdmin = false;
        //TODO 当前登录人所属租户id
        String loginTenantBizId = "";
        //添加和编辑校验入参的唯一性
        addAndEditReqCheckCommon(request.getUserName(),
                request.getMobile(),
                request.getEmail(),
                CommonEnum.OPR_SOURCE_ADD.getCode(),"");

        //新增用户数据
        SysUser sysUser = new SysUser();
        BeanUtils.copyProperties(request,sysUser);
        //TODO 修改密码，加密密码
        //用户业务唯一id
        sysUser.setUserBizId(RandomStringGenerator.generateBizId16(CommonEnum.UID_TYPE_USER.getCode()));
        sysUser.setIsSuperAdmin(0);
        sysUser.setLastPasswordTime(now);
        sysUser.setSourceType(1);
        iSysUserService.saveOrUpdate(sysUser);

        if (!isAdmin) {
            //非超级管理员，添加租户和用户的关系
            apiRelTenantUserService.addSingleRel(loginTenantBizId,sysUser.getUserBizId());
        }
        return Result.success();
    }

    /**
     * 编辑用户
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiSysUserEditRequest request) {
        LocalDateTime now = LocalDateTime.now();

        //校验用户是否存在
        Result<SysUser> result = checkSysUserIsExist(request.getUserBizId());
        SysUser sysUser = result.getData();

        //添加和编辑校验入参的唯一性
        addAndEditReqCheckCommon(request.getUserName(),
                request.getMobile(),
                request.getEmail(),
                CommonEnum.OPR_SOURCE_EDIT.getCode(),request.getUserBizId());

        //编辑用户
        BeanUtils.copyProperties(request,sysUser);
        //TODO 修改密码，加密密码
        sysUser.setLastPasswordTime(now);
        iSysUserService.saveOrUpdate(sysUser);

        return Result.success();
    }


    /**
     * 添加和编辑校验入参的唯一性
     * @param userName
     * @param mobile
     * @param email
     */
    public void addAndEditReqCheckCommon(String userName,String mobile,String email,String oprSource,String userBizId) {
        Boolean isExcludeMy = true;
        if (CommonEnum.OPR_SOURCE_ADD.getCode().equals(oprSource)) {
            //添加来源
            userBizId = "";
            isExcludeMy = false;
        }
        List<SysUser> userNameList = iSysUserService.queryList(SysUserDto.builder()
                .userName(userName)
                .userBizId(userBizId)
                .isExcludeMy(isExcludeMy)
                .build());
        if (!CollectionUtils.isEmpty(userNameList)) {
            throw new BusinessException("用户账号已存在");
        }

        List<SysUser> mobileList = iSysUserService.queryList(SysUserDto.builder()
                .userName(mobile)
                .userBizId(userBizId)
                .isExcludeMy(isExcludeMy)
                .build());
        if (!CollectionUtils.isEmpty(mobileList)) {
            throw new BusinessException("手机号已存在");
        }

        List<SysUser> emailList = iSysUserService.queryList(SysUserDto.builder()
                .userName(email)
                .userBizId(userBizId)
                .isExcludeMy(isExcludeMy)
                .build());
        if (!CollectionUtils.isEmpty(emailList)) {
            throw new BusinessException("邮箱已存在");
        }

    }

    /**
     * 获取用户详情
     * @param userBizId
     * @return
     */
    @Override
    public Result<ApiSysUserDetailResponse> detail(String userBizId) {
        SysUser sysUser = iSysUserService.queryOne(userBizId);
        ApiSysUserDetailResponse response = null;
        if (!Objects.isNull(sysUser)) {
            response = new ApiSysUserDetailResponse();
            BeanUtils.copyProperties(sysUser,response);
        }

        return Result.success(response);
    }

    /**
     * 编辑用户状态
     * @param userBizId
     * @param status
     * @return
     */
    @Override
    public Result editStatus(String userBizId, Integer status) {
        //校验用户是否存在
        Result<SysUser> result = checkSysUserIsExist(userBizId);
        SysUser sysUser = result.getData();

        sysUser.setStatus(status);
        iSysUserService.saveOrUpdate(sysUser);
        return Result.success();
    }

    /**
     * 校验用户是否存在
     * @param userBizId
     * @return
     */
    public Result<SysUser> checkSysUserIsExist(String userBizId) {
        SysUser sysUser = iSysUserService.queryOne(userBizId);
        if (Objects.isNull(sysUser)) {
            //数据不存在
            throw new BusinessException(ResultCode.NULL_ERROR.getCode(),ResultCode.NULL_ERROR.getMessage());
        }
        return Result.success(sysUser);
    }
}
