package com.yd.user.feign.fallback.reltenantmenu;

import com.yd.common.result.Result;
import com.yd.user.feign.client.reltenantmenu.ApiRelTenantMenuFeignClient;
import com.yd.user.feign.request.reltenantmenu.ApiRelTenantMenuListAddRequest;
import com.yd.user.feign.request.reltenantmenu.ApiRelTenantMenuListPageRequest;
import com.yd.user.feign.request.reltenantmenu.ApiRelTenantMenuSelectPageRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 用户服务：租户-菜单关系信息Feign降级处理
 */
@Slf4j
@Component
public class ApiRelTenantMenuFeignFallbackFactory implements FallbackFactory<ApiRelTenantMenuFeignClient> {
    @Override
    public ApiRelTenantMenuFeignClient create(Throwable cause) {
        return new ApiRelTenantMenuFeignClient() {
            @Override
            public Result page(ApiRelTenantMenuListPageRequest request) {
                return null;
            }

            @Override
            public Result addMenuList(ApiRelTenantMenuListAddRequest request) {
                return null;
            }

            @Override
            public Result del(Long id) {
                return null;
            }

            @Override
            public Result selectMenuPage(ApiRelTenantMenuSelectPageRequest request) {
                return null;
            }
        };
    }
}
