package com.yd.user.feign.fallback.reluserrole;

import com.yd.common.result.Result;
import com.yd.user.feign.client.reluserrole.ApiRelUserRoleFeignClient;
import com.yd.user.feign.request.reluserrole.ApiProjectUserRoleListAddRequest;
import com.yd.user.feign.request.reluserrole.ApiTenantUserRoleListAddRequest;
import com.yd.user.feign.response.reluserrole.ApiSelectedTenantUserRoleListResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 用户服务：用户-角色关系信息Feign降级处理
 */
@Slf4j
@Component
public class ApiRelUserRoleFeignFallbackFactory implements FallbackFactory<ApiRelUserRoleFeignClient> {
    @Override
    public ApiRelUserRoleFeignClient create(Throwable cause) {
        return new ApiRelUserRoleFeignClient() {
            @Override
            public Result addTenantUserRoleList(ApiTenantUserRoleListAddRequest request) {
                return null;
            }

            @Override
            public Result<List<ApiSelectedTenantUserRoleListResponse>> selectedTenantUserRoleList(String tenantBizId, String userBizId) {
                return null;
            }

            @Override
            public Result addProjectUserRoleList(ApiProjectUserRoleListAddRequest request) {
                return null;
            }

            @Override
            public Result selectedProjectUserRoleList(String projectBizId,String userBizId) {
                return null;
            }
        };
    }
}
