package com.yd.user.feign.request.relprojectuser;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * 添加项目和用户列表关系入参
 */
@Data
public class ApiRelProjectUserListAddRequest {

    /**
     * 项目ID（业务id）
     */
    @NotBlank(message = "项目ID（业务id）不能为空")
    private String projectBizId;

    /**
     * 选择的用户ID（业务id）列表
     */
    @NotEmpty(message = "选择的用户ID（业务id）列表不能为空")
    private List<String> userBizIdList;
}
