package com.yd.user.service.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 项目公共参数对象
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class SysProjectDto {

    /**
     * 项目主键id
     */
    private Long id;

    /**
     * 项目唯一标识(业务ID)
     */
    private String projectBizId;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 状态(0:禁用 1:启用)
     */
    private Integer status;

    /**
     * 查询是否排除当前项目唯一标识数据，默认false不排除，true的话projectBizId必传
     */
    private Boolean isExcludeMy = false;

}
