package com.yd.user.service.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.user.feign.request.reltenantrole.ApiRelTenantRoleListPageRequest;
import com.yd.user.feign.request.reltenantrole.ApiRelTenantRoleSelectPageRequest;
import com.yd.user.feign.response.reltenantrole.ApiRelTenantRoleListPageResponse;
import com.yd.user.feign.response.reltenantrole.ApiRelTenantRoleSelectPageResponse;
import com.yd.user.service.model.RelTenantProject;
import com.yd.user.service.model.RelTenantRole;
import com.baomidou.mybatisplus.extension.service.IService;

/**
 * <p>
 * 租户-角色关系表（正常来说一对多，加关系表方便扩展） 服务类
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
public interface IRelTenantRoleService extends IService<RelTenantRole> {

    IPage<ApiRelTenantRoleListPageResponse> page(Page<ApiRelTenantRoleListPageResponse> page,
                                                 ApiRelTenantRoleListPageRequest request);

    RelTenantRole queryOne(Long id);

    IPage<ApiRelTenantRoleSelectPageResponse> selectProjectPage(Page<ApiRelTenantRoleSelectPageResponse> page,
                                                                ApiRelTenantRoleSelectPageRequest request);
}
