package com.yd.user.service.service;

import com.yd.user.feign.response.reluserrole.ApiSelectedProjectUserRoleListResponse;
import com.yd.user.feign.response.reluserrole.ApiSelectedTenantUserRoleListResponse;
import com.yd.user.service.model.RelUserRole;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;

/**
 * <p>
 * 用户-角色关系表（多对多关系） 服务类
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
public interface IRelUserRoleService extends IService<RelUserRole> {

    void delRelTenantUserRole(String tenantBizId,String userBizId);

    void delRelProjectUserRole(String projectBizId,String userBizId);

    List<ApiSelectedTenantUserRoleListResponse> selectedTenantUserRoleList(String tenantBizId, String userBizId);

    List<ApiSelectedProjectUserRoleListResponse> selectedProjectUserRoleList(String projectBizId, String userBizId);
}
