package com.yd.user.service.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.user.feign.request.relprojectrole.ApiRelProjectRoleListPageRequest;
import com.yd.user.feign.request.relprojectrole.ApiRelProjectRoleSelectPageRequest;
import com.yd.user.feign.response.relprojectrole.ApiRelProjectRoleListPageResponse;
import com.yd.user.feign.response.relprojectrole.ApiRelProjectRoleSelectPageResponse;
import com.yd.user.service.model.RelProjectRole;
import com.yd.user.service.dao.RelProjectRoleMapper;
import com.yd.user.service.service.IRelProjectRoleService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 项目-角色关系表（正常来说一对多，加关系表方便扩展） 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
@Service
public class RelProjectRoleServiceImpl extends ServiceImpl<RelProjectRoleMapper, RelProjectRole> implements IRelProjectRoleService {

    /**
     * 项目和角色关系分页查询
     * @param request
     * @return
     */
    @Override
    public IPage<ApiRelProjectRoleListPageResponse> page(Page<ApiRelProjectRoleListPageResponse> page, ApiRelProjectRoleListPageRequest request) {
        return baseMapper.page(page,request);
    }

    /**
     * 导入-选择角色分页查询（查询当前项目级（当前所属项目绑定的角色）或者系统级（全局角色在任何地方都适用导入绑定）的角色表数据）
     * @param request
     * @return
     */
    @Override
    public IPage<ApiRelProjectRoleSelectPageResponse> selectProjectPage(Page<ApiRelProjectRoleSelectPageResponse> page,
                                                                        ApiRelProjectRoleSelectPageRequest request) {
        return baseMapper.selectProjectPage(page,request);
    }


    /**
     * 删除项目和角色关系
     * @param id 项目和角色关系表主键id
     * @return
     */
    @Override
    public RelProjectRole queryOne(Long id) {
        return this.getById(id);
    }
}
