package com.yd.user.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.user.feign.response.reluserrole.ApiSelectedProjectUserRoleListResponse;
import com.yd.user.feign.response.reluserrole.ApiSelectedTenantUserRoleListResponse;
import com.yd.user.service.model.RelUserRole;
import com.yd.user.service.dao.RelUserRoleMapper;
import com.yd.user.service.service.IRelUserRoleService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 用户-角色关系表（多对多关系） 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
@Service
public class RelUserRoleServiceImpl extends ServiceImpl<RelUserRoleMapper, RelUserRole> implements IRelUserRoleService {

    /**
     * 删除租户用户角色关系
     * @param tenantBizId
     * @param userBizId
     */
    @Override
    public void delRelTenantUserRole(String tenantBizId, String userBizId) {
        this.remove(new LambdaQueryWrapper<RelUserRole>()
                .eq(RelUserRole::getTenantBizId,tenantBizId)
                .eq(RelUserRole::getUserBizId,userBizId)
        );
    }

    /**
     * 删除项目用户角色关系
     * @param projectBizId
     * @param userBizId
     */
    @Override
    public void delRelProjectUserRole(String projectBizId, String userBizId) {
        this.remove(new LambdaQueryWrapper<RelUserRole>()
                .eq(RelUserRole::getProjectBizId,projectBizId)
                .eq(RelUserRole::getUserBizId,userBizId)
        );
    }

    /**
     * 租户管理-用户配置-权限配置-查询选中的角色列表
     * @return
     */
    @Override
    public List<ApiSelectedTenantUserRoleListResponse> selectedTenantUserRoleList(String tenantBizId, String userBizId) {
        return baseMapper.selectedTenantUserRoleList(tenantBizId,userBizId);
    }

    /**
     * 项目管理-用户配置-权限配置-查询选中的角色列表
     * @return
     */
    @Override
    public List<ApiSelectedProjectUserRoleListResponse> selectedProjectUserRoleList(String projectBizId, String userBizId) {
        return baseMapper.selectedProjectUserRoleList(projectBizId,userBizId);
    }
}
