package com.yd.user.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yd.user.service.dto.SysMenuDto;
import com.yd.user.service.model.SysMenu;
import com.yd.user.service.dao.SysMenuMapper;
import com.yd.user.service.model.SysRole;
import com.yd.user.service.service.ISysMenuService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 菜单权限表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
@Service
public class SysMenuServiceImpl extends ServiceImpl<SysMenuMapper, SysMenu> implements ISysMenuService {

    /**
     * 查询单个对象
     * @param menuBizId
     * @return
     */
    @Override
    public SysMenu queryOne(String menuBizId) {
        return this.getOne(new LambdaQueryWrapper<SysMenu>().eq(SysMenu::getMenuBizId,menuBizId));
    }

    /**
     * 根据条件查询菜单列表
     * @param dto
     * @return
     */
    @Override
    public List<SysMenu> queryList(SysMenuDto dto) {
        List<SysMenu> list = baseMapper.selectList(new LambdaQueryWrapper<SysMenu>()
                .eq(!Objects.isNull(dto.getId()),SysMenu::getId,dto.getId())
                .eq(StringUtils.isNotBlank(dto.getMenuBizId()) && !dto.getIsExcludeMy(),SysMenu::getMenuBizId,dto.getMenuBizId())
                .eq(StringUtils.isNotBlank(dto.getMenuName()),SysMenu::getMenuName,dto.getMenuName())
                .ne(dto.getIsExcludeMy(),SysMenu::getMenuBizId,dto.getMenuBizId())
        );
        return list;
    }
}
