package com.yd.user.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.user.feign.request.sysproject.ApiSysProjectPageRequest;
import com.yd.user.feign.response.sysproject.ApiSysProjectPageResponse;
import com.yd.user.service.dto.SysProjectDto;
import com.yd.user.service.model.SysProject;
import com.yd.user.service.dao.SysProjectMapper;
import com.yd.user.service.model.SysTenant;
import com.yd.user.service.service.ISysProjectService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 项目信息表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
@Service
public class SysProjectServiceImpl extends ServiceImpl<SysProjectMapper, SysProject> implements ISysProjectService {

    /**
     * 项目分页查询
     * @param page
     * @param request
     * @return
     */
    @Override
    public IPage<ApiSysProjectPageResponse> page(Page<ApiSysProjectPageResponse> page,
                                                 ApiSysProjectPageRequest request,
                                                 Boolean isAdmin,String loginTenantBizId) {
        return baseMapper.page(page,request,isAdmin,loginTenantBizId);
    }

    /**
     * 查询单个对象
     * @param projectBizId
     * @return
     */
    @Override
    public SysProject queryOne(String projectBizId) {
        return this.getOne(new LambdaQueryWrapper<SysProject>().eq(SysProject::getProjectBizId,projectBizId));
    }

    /**
     * 查询项目列表信息
     * @param dto
     * @return
     */
    @Override
    public List<SysProject> queryList(SysProjectDto dto) {
        List<SysProject> list = baseMapper.selectList(new LambdaQueryWrapper<SysProject>()
                .eq(!Objects.isNull(dto.getId()),SysProject::getId,dto.getId())
                .eq(StringUtils.isNotBlank(dto.getProjectBizId()) && !dto.getIsExcludeMy(),SysProject::getProjectBizId,dto.getProjectBizId())
                .eq(StringUtils.isNotBlank(dto.getProjectName()),SysProject::getProjectName,dto.getProjectName())
                .eq(!Objects.isNull(dto.getStatus()),SysProject::getStatus,dto.getStatus())
                .ne(dto.getIsExcludeMy(),SysProject::getProjectBizId,dto.getProjectBizId())
        );
        return list;
    }
}
