package com.yd.user.feign.client.reldeptuser;

import com.yd.common.result.Result;
import com.yd.user.feign.fallback.reldeptuser.ApiRelDeptUserFeignFallbackFactory;
import com.yd.user.feign.request.reldeptuser.ApiRelTenantDeptUserDelRequest;
import com.yd.user.feign.request.reldeptuser.ApiRelTenantDeptUserImportAddRequest;
import com.yd.user.feign.request.reldeptuser.ApiRelTenantDeptUserImportPageRequest;
import com.yd.user.feign.request.reldeptuser.ApiRelTenantDeptUserPageRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 用户服务：部门-用户关系信息Feign客户端
 */
@FeignClient(name = "yd-user-api", fallbackFactory = ApiRelDeptUserFeignFallbackFactory.class)
public interface ApiRelDeptUserFeignClient {

    /**
     * 租户管理-分配权限-部门配置-用户列表
     * @param request
     * @return
     */
    @PostMapping("/tenant/page")
    Result page(@Validated @RequestBody ApiRelTenantDeptUserPageRequest request);

    /**
     * 租户管理-分配权限-部门配置-用户列表删除
     * @param request
     * @return
     */
    @PostMapping("/tenant/del")
    Result del(@Validated @RequestBody ApiRelTenantDeptUserDelRequest request);

    /**
     * 租户管理-分配权限-部门配置-用户列表导入分页查询
     * @param request
     * @return
     */
    @PostMapping("/tenant/import/page")
    Result importPage(@Validated @RequestBody ApiRelTenantDeptUserImportPageRequest request);

    /**
     * 租户管理-分配权限-部门配置-用户列表导入添加
     * @param request
     * @return
     */
    @PostMapping("/tenant/import/add")
    Result importAdd(@Validated @RequestBody ApiRelTenantDeptUserImportAddRequest request);

}
