package com.yd.user.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 客户端用户表
 * </p>
 *
 * @author zxm
 * @since 2025-10-20
 */
@Getter
@Setter
@TableName("client_user")
public class ClientUser implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 客户端用户表唯一业务ID
     */
    @TableField("client_user_biz_id")
    private String clientUserBizId;

    /**
     * 头像
     */
    @TableField("avatar")
    private String avatar;

    /**
     * 姓名
     */
    @TableField("name")
    private String name;

    /**
     * 手机号
     */
    @TableField("phone")
    private String phone;

    /**
     * 邮箱
     */
    @TableField("email")
    private String email;

    /**
     * 证件类型
     */
    @TableField("id_card_type")
    private String idCardType;

    /**
     * 证件号码
     */
    @TableField("id_card_number")
    private String idCardNumber;

    /**
     * 证件文件url（多个分号分开）
     */
    @TableField("id_card_file_url")
    private String idCardFileUrl;

    /**
     * 银行卡号
     */
    @TableField("bank_number")
    private String bankNumber;

    /**
     * 开户行
     */
    @TableField("open_bank")
    private String openBank;

    /**
     * 银行卡文件url（多个分号分开）
     */
    @TableField("bank_file_url")
    private String bankFileUrl;

    /**
     * 登录密码
     */
    @TableField("password")
    private String password;

    /**
     * 邀请码
     */
    @TableField("invitation_code")
    private String invitationCode;

    /**
     * 状态(0:停用 1:启用)
     */
    @TableField("status")
    private Integer status;

    /**
     * 审批状态
     */
    @TableField("approval_status")
    private String approvalStatus;

    /**
     * 注册来源（PC、小程序等）默认小程序 - MINI_PROGRAM
     */
    @TableField("register_source")
    private String registerSource;

    /**
     * 所属租户唯一业务ID（冗余）
     */
    @TableField("tenant_biz_id")
    private String tenantBizId;

    /**
     * 所属项目唯一业务ID（冗余）
     */
    @TableField("project_biz_id")
    private String projectBizId;

    /**
     * 用户唯一标识(sys_user系统用户表)
     */
    @TableField("user_biz_id")
    private String userBizId;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
