package com.yd.user.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.common.enums.ResultCode;
import com.yd.common.exception.BusinessException;
import com.yd.common.result.Result;
import com.yd.user.api.service.ApiSysUserService;
import com.yd.user.feign.request.sysuser.ApiSysUserAddRequest;
import com.yd.user.feign.request.sysuser.ApiSysUserEditRequest;
import com.yd.user.feign.request.sysuser.ApiSysUserPageRequest;
import com.yd.user.feign.response.sysuser.ApiSysUserDetailResponse;
import com.yd.user.feign.response.sysuser.ApiSysUserPageResponse;
import com.yd.user.service.model.SysUser;
import com.yd.user.service.service.ISysUserService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

@Service
public class ApiSysUserServiceImpl implements ApiSysUserService {

    @Autowired
    private ISysUserService iSysUserService;

    /**
     * 用户分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiSysUserPageResponse>> page(ApiSysUserPageRequest request) {
        Page<ApiSysUserPageResponse> page = new Page<>(request.getPageNo(), request.getPageSize());
        IPage<ApiSysUserPageResponse> iPage = iSysUserService.page(page, request);
        return Result.success(iPage);
    }

    /**
     * 添加用户
     * @param request
     * @return
     */
    @Override
    public Result add(ApiSysUserAddRequest request) {
        return null;
    }

    /**
     * 编辑用户
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiSysUserEditRequest request) {
        return null;
    }

    /**
     * 获取用户详情
     * @param userUid
     * @return
     */
    @Override
    public Result<ApiSysUserDetailResponse> detail(String userUid) {
        SysUser sysUser = iSysUserService.queryOne(userUid);
        ApiSysUserDetailResponse response = null;
        if (!Objects.isNull(sysUser)) {
            response = new ApiSysUserDetailResponse();
            BeanUtils.copyProperties(sysUser,response);
        }

        return Result.success(response);
    }
}
