package com.yd.user.feign.client.systenant;

import com.yd.common.result.Result;
import com.yd.user.feign.fallback.systenant.ApiSysTenantFeignFallbackFactory;
import com.yd.user.feign.request.systenant.ApiSysTenantAddRequest;
import com.yd.user.feign.request.systenant.ApiSysTenantEditRequest;
import com.yd.user.feign.request.systenant.ApiSysTenantPageRequest;
import com.yd.user.feign.response.systenant.ApiSysTenantDetailResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import javax.validation.constraints.NotBlank;

/**
 * 用户服务-系统租户信息Feign客户端
 */
@FeignClient(name = "yd-user-api", fallbackFactory = ApiSysTenantFeignFallbackFactory.class)
public interface ApiSysTenantFeignClient {

    /**
     * 租户分页查询
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiSysTenantPageRequest request);

    /**
     * 获取租户详情
     * @param tenantUid 租户唯一标识(业务ID)
     * @return
     */
    @GetMapping("/detail")
    Result<ApiSysTenantDetailResponse> detail(@NotBlank(message = "租户唯一标识(业务ID)不能为空") @RequestParam(value = "tenantUid") String tenantUid);

    /**
     * 添加租户
     * @param request
     * @return
     */
    @PostMapping("/add")
    Result add(@Validated @RequestBody ApiSysTenantAddRequest request);

    /**
     * 编辑租户
     * @param request
     * @return
     */
    @PostMapping("/edit")
    Result edit(@RequestBody ApiSysTenantEditRequest request);


    /**
     * 删除租户（逻辑删除）
     * @param tenantUid 租户唯一标识(业务ID)
     * @return
     */
    @DeleteMapping("/del")
    Result del(@RequestParam(value = "tenantUid") String tenantUid);

    /**
     * 编辑租户状态
     * @param tenantUid 租户唯一标识(业务ID)
     * @param status 状态(0:禁用 1:启用)
     * @return
     */
    @DeleteMapping("/edit/status")
    Result editStatus(@RequestParam(value = "tenantUid") String tenantUid,
                      @RequestParam(value = "status") Integer status);
}
