package com.yd.user.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.user.api.service.ApiSysUserService;
import com.yd.user.feign.client.sysuser.ApiSysUserFeignClient;
import com.yd.user.feign.request.sysuser.ApiSysUserAddRequest;
import com.yd.user.feign.request.sysuser.ApiSysUserEditRequest;
import com.yd.user.feign.request.sysuser.ApiSysUserPageRequest;
import com.yd.user.feign.response.sysuser.ApiSysUserDetailResponse;
import com.yd.user.feign.response.sysuser.ApiSysUserPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 用户信息
 *
 * @author zxm
 * @since 2025-07-31
 */
@RestController
@RequestMapping("/sysUser")
public class ApiSysUserController implements ApiSysUserFeignClient {

    @Autowired
    private ApiSysUserService apiSysUserService;

    /**
     * 用户分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiSysUserPageResponse>> page(ApiSysUserPageRequest request) {
        return apiSysUserService.page(request);
    }

    /**
     * 添加用户
     * @param request
     * @return
     */
    @Override
    public Result add(ApiSysUserAddRequest request) {
        return apiSysUserService.add(request);
    }

    /**
     * 编辑用户
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiSysUserEditRequest request) {
        return apiSysUserService.edit(request);
    }

    /**
     * 获取用户详情
     * @param userUid 用户业务唯一标识id
     * @return
     */
    public Result<ApiSysUserDetailResponse> detail(String userUid) {
        return apiSysUserService.detail(userUid);
    }
}
