package com.yd.user.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.user.api.service.ApiSysDeptService;
import com.yd.user.feign.client.sysdept.ApiSysDeptFeignClient;
import com.yd.user.feign.request.sysdept.*;
import com.yd.user.feign.response.sysdept.ApiSysDeptCompanyPageResponse;
import com.yd.user.feign.response.sysdept.ApiSysDeptDetailResponse;
import com.yd.user.feign.response.sysdept.ApiSysDeptPageResponse;
import com.yd.user.feign.response.sysdept.ApiSysDeptTreeListResponse;
import com.yd.user.feign.response.sysmenu.ApiSysMenuPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 部门信息（部门信息）
 *
 * @author zxm
 * @since 2025-07-31
 */
@RestController
@RequestMapping("/sysDept")
@Validated
public class ApiSysDeptController implements ApiSysDeptFeignClient {

    @Autowired
    private ApiSysDeptService apiSysDeptService;

    /**
     * 树形部门列表查询
     * @param request
     * @return
     */
    @Override
    public Result<List<ApiSysDeptTreeListResponse>> treeList(ApiSysDeptTreeListRequest request) {
        return apiSysDeptService.treeList(request);
    }

    /**
     * 部门分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiSysDeptPageResponse>> page(ApiSysDeptPageRequest request) {
        return apiSysDeptService.page(request);
    }

    /**
     * 公司分页查询（公司类型）
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiSysDeptCompanyPageResponse>> companyPage(ApiSysDeptCompanyPageRequest request) {
        return apiSysDeptService.companyPage(request);
    }

    /**
     * 获取部门详情
     * @param deptBizId 部门唯一标识(业务ID)
     * @return
     */
    @Override
    public Result<ApiSysDeptDetailResponse> detail(String deptBizId) {
        return apiSysDeptService.detail(deptBizId);
    }

    /**
     * 添加部门
     * @param request
     * @return
     */
    @Override
    public Result add(ApiSysDeptAddRequest request) {
        return apiSysDeptService.add(request);
    }

    /**
     * 编辑部门
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiSysDeptEditRequest request) {
        return apiSysDeptService.edit(request);
    }

    /**
     * 删除部门（逻辑删除） TODO
     * @param deptBizId 部门唯一标识(业务ID)
     * @return
     */
    @Override
    public Result del(String deptBizId) {
        return apiSysDeptService.del(deptBizId);
    }

    /**
     * 编辑部门状态 TODO
     * @param deptBizId 部门唯一标识(业务ID)
     * @param status 状态(0:禁用 1:启用)
     * @return
     */
    @Override
    public Result editStatus(String deptBizId, Integer status) {
        return apiSysDeptService.editStatus(deptBizId,status);
    }
}
