package com.yd.user.feign.request.relprojectrole;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * 添加项目和角色列表关系入参
 */
@Data
public class ApiRelProjectRoleListAddRequest {
    
    /**
     * 项目唯一标识(业务ID)
     */
    @NotBlank(message = "项目唯一标识(业务ID)不能为空")
    private String projectBizId;

    /**
     * 角色唯一标识(业务ID) 列表（选中列表）
     */
    @NotEmpty(message = "角色唯一标识(业务ID) 列表（选中列表）不能为空")
    private List<String> roleBizIdList;

}
