package com.yd.user.feign.request.reluserrole;

import lombok.Data;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;

@Data
public class ApiProjectUserRoleListDelRequest {

    /**
     * 项目ID（业务id）
     */
    @NotBlank(message = "项目ID（业务id）不能为空")
    private String projectBizId;

    /**
     * 用户ID（业务id）
     */
    @NotBlank(message = "用户ID（业务id）不能为空")
    private String userBizId;

    /**
     * 选择的角色ID（业务id）列表
     */
    @NotEmpty(message = "选择的角色ID（业务id）列表不能为空")
    private List<String> roleBizIdList;
}
