package com.yd.user.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.user.api.service.ApiRelTenantMenuService;
import com.yd.user.feign.client.reltenantmenu.ApiRelTenantMenuFeignClient;
import com.yd.user.feign.request.reltenantmenu.ApiRelTenantMenuListAddRequest;
import com.yd.user.feign.request.reltenantmenu.ApiRelTenantMenuListPageRequest;
import com.yd.user.feign.request.reltenantmenu.ApiRelTenantMenuImportQueryMenuTreeRequest;
import com.yd.user.feign.request.reltenantmenu.ApiRelTenantMenuTreeListRequest;
import com.yd.user.feign.response.reltenantmenu.ApiRelTenantMenuListPageResponse;
import com.yd.user.feign.response.reltenantmenu.ApiRelTenantMenuImportQueryMenuTreeResponse;
import com.yd.user.feign.response.reltenantmenu.ApiRelTenantMenuTreeListResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 租户-菜单关系信息（租户管理-菜单配置）
 *
 * @author zxm
 * @since 2025-07-31
 */
@RestController
@RequestMapping("/relTenantMenu")
@Validated
public class ApiRelTenantMenuController implements ApiRelTenantMenuFeignClient {

    @Autowired
    private ApiRelTenantMenuService apiRelTenantMenuService;

    /**
     * 租户和菜单关系分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiRelTenantMenuListPageResponse>> page(ApiRelTenantMenuListPageRequest request) {
        return apiRelTenantMenuService.page(request);
    }

    /**
     * 租户和菜单关系树形列表查询
     * @param request
     * @return
     */
    @Override
    public Result<List<ApiRelTenantMenuTreeListResponse>> tree(ApiRelTenantMenuTreeListRequest request) {
        return apiRelTenantMenuService.tree(request);
    }

    /**
     * 添加租户和菜单列表关系
     * @param request
     * @return
     */
    @Override
    public Result addMenuList(ApiRelTenantMenuListAddRequest request) {
        return apiRelTenantMenuService.addMenuList(request);
    }

    /**
     * 删除租户和菜单关系
     * @param id 租户和菜单关系表主键id
     * @return
     */
    @Override
    public Result del(Long id) {
        return apiRelTenantMenuService.del(id);
    }

    /**
     * 导入-树形菜单查询
     * @param request
     * @return
     */
    @Override
    public Result<List<ApiRelTenantMenuImportQueryMenuTreeResponse>> importQueryMenuTree(ApiRelTenantMenuImportQueryMenuTreeRequest request) {

        return apiRelTenantMenuService.importQueryMenuTree(request);
    }

    /**
     * 导入-树形菜单-查询选中的菜单id集合
     * @param tenantBizId
     * @return
     */
    @Override
    public Result<List<String>> selectedList(String tenantBizId) {
        return apiRelTenantMenuService.selectedList(tenantBizId);
    }

}
