package com.yd.user.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.common.enums.ResultCode;
import com.yd.common.exception.BusinessException;
import com.yd.common.result.Result;
import com.yd.user.api.service.ApiRelProjectRoleService;
import com.yd.user.feign.request.relprojectrole.ApiRelProjectRoleListAddRequest;
import com.yd.user.feign.request.relprojectrole.ApiRelProjectRoleListPageRequest;
import com.yd.user.feign.request.relprojectrole.ApiRelProjectRoleSelectPageRequest;
import com.yd.user.feign.response.relprojectrole.ApiRelProjectRoleListPageResponse;
import com.yd.user.feign.response.relprojectrole.ApiRelProjectRoleSelectPageResponse;
import com.yd.user.feign.response.reltenantrole.ApiRelTenantRoleListPageResponse;
import com.yd.user.feign.response.reltenantrole.ApiRelTenantRoleSelectPageResponse;
import com.yd.user.service.model.RelProjectRole;
import com.yd.user.service.model.RelTenantRole;
import com.yd.user.service.service.IRelProjectRoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Service
public class ApiRelProjectRoleServiceImpl implements ApiRelProjectRoleService {

    @Autowired
    private IRelProjectRoleService iRelProjectRoleService;

    /**
     * 项目和角色关系分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiRelProjectRoleListPageResponse>> page(ApiRelProjectRoleListPageRequest request) {
        Page<ApiRelProjectRoleListPageResponse> page = new Page<>(request.getPageNo(), request.getPageSize());
        IPage<ApiRelProjectRoleListPageResponse> iPage = iRelProjectRoleService.page(page, request);
        return Result.success(iPage);
    }

    /**
     * 添加项目和角色列表关系
     * @param request
     * @return
     */
    @Override
    public Result addRoleList(ApiRelProjectRoleListAddRequest request) {
        List<RelProjectRole> list = new ArrayList<>();
        if (!CollectionUtils.isEmpty(request.getRoleBizIdList())) {
            //角色唯一标识(业务ID) 列表（选中列表）不为空
            list = request.getRoleBizIdList().stream().map(bizId -> {
                RelProjectRole relProjectRole = new RelProjectRole();
                relProjectRole.setTenantBizId(request.getTenantBizId());
                relProjectRole.setProjectBizId(request.getProjectBizId());
                relProjectRole.setRoleBizId(bizId);
                return relProjectRole;
            }).collect(Collectors.toList());

            iRelProjectRoleService.saveOrUpdateBatch(list);
        }

        return Result.success();
    }

    /**
     * 删除项目和角色关系
     * @param id 项目和角色关系表主键id
     * @return
     */
    @Override
    public Result del(Long id) {
        RelProjectRole relProjectRole = iRelProjectRoleService.queryOne(id);
        if (Objects.isNull(relProjectRole)) {
            //数据不存在
            throw new BusinessException(ResultCode.NULL_ERROR.getCode(),ResultCode.NULL_ERROR.getMessage());
        }
        iRelProjectRoleService.removeById(relProjectRole.getId());
        return Result.success();
    }

    /**
     * 导入-选择角色分页查询（查询当前项目级（当前所属项目绑定的角色）或者系统级（全局角色在任何地方都适用导入绑定）的角色表数据）
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiRelProjectRoleSelectPageResponse>> selectRolePage(ApiRelProjectRoleSelectPageRequest request) {
        Page<ApiRelProjectRoleSelectPageResponse> page = new Page<>(request.getPageNo(), request.getPageSize());
        IPage<ApiRelProjectRoleSelectPageResponse> iPage = iRelProjectRoleService.selectProjectPage(page, request);
        return Result.success(iPage);
    }

    /**
     * 添加单个关系
     * @param projectBizId
     * @param roleBizId
     * @return
     */
    @Override
    public Result addSingleRel(String projectBizId, String roleBizId) {
        RelProjectRole relProjectRole = new RelProjectRole();
        relProjectRole.setProjectBizId(projectBizId);
        relProjectRole.setRoleBizId(roleBizId);
        iRelProjectRoleService.saveOrUpdate(relProjectRole);
        return Result.success();
    }

}
