package com.yd.user.feign.client.sysrole;

import com.yd.common.result.Result;
import com.yd.user.feign.fallback.sysrole.ApiSysRoleFeignFallbackFactory;
import com.yd.user.feign.request.sysrole.ApiSysRoleAddRequest;
import com.yd.user.feign.request.sysrole.ApiSysRoleEditRequest;
import com.yd.user.feign.request.sysrole.ApiSysRolePageRequest;
import com.yd.user.feign.response.sysrole.ApiSysRoleDetailResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 用户服务-系统角色信息Feign客户端
 */
@FeignClient(name = "yd-user-api", fallbackFactory = ApiSysRoleFeignFallbackFactory.class)
public interface ApiSysRoleFeignClient {

    /**
     * 角色分页查询
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiSysRolePageRequest request);

    /**
     * 获取角色详情
     * @param roleBizId 角色唯一标识(业务ID)
     * @return
     */
    @GetMapping("/detail")
    Result<ApiSysRoleDetailResponse> detail(@NotBlank(message = "角色唯一标识(业务ID)不能为空") @RequestParam(value = "roleBizId") String roleBizId);

    /**
     * 添加角色
     * @param request
     * @return
     */
    @PostMapping("/add")
    Result add(@Validated @RequestBody ApiSysRoleAddRequest request);

    /**
     * 编辑角色
     * @param request
     * @return
     */
    @PutMapping("/edit")
    Result edit(@Validated @RequestBody ApiSysRoleEditRequest request);


    /**
     * 删除角色（逻辑删除）
     * @param roleBizId 角色唯一标识(业务ID)
     * @return
     */
    @DeleteMapping("/del")
    Result del(@RequestParam(value = "roleBizId") String roleBizId);

    /**
     * 编辑角色状态
     * @param roleBizId 角色唯一标识(业务ID)
     * @param status 状态(0:禁用 1:启用)
     * @return
     */
    @PatchMapping("/edit/status")
    Result editStatus(@NotBlank(message = "角色唯一标识(业务ID)不能为空") @RequestParam(value = "roleBizId") String roleBizId,
                      @NotNull(message = "状态不能为空") @RequestParam(value = "status") Integer status);
}
