package com.yd.user.feign.request.relprojectmenu;

import com.yd.common.dto.PageDto;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 项目和菜单关系分页查询入参
 */
@Data
public class ApiRelProjectMenuTreeListRequest extends PageDto {

    /**
     * 租户唯一标识(业务ID)
     */
    @NotBlank(message = "租户唯一标识(业务ID)不能为空")
    private String tenantBizId;

    /**
     * 项目唯一标识(业务ID)
     */
    @NotBlank(message = "项目唯一标识(业务ID)不能为空")
    private String projectBizId;

    /**
     * 菜单名称
     */
    private String menuName;
}
