package com.yd.user.service.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.user.feign.request.sysuser.ApiScopePageRequest;
import com.yd.user.feign.request.sysuser.ApiSysUserPageRequest;
import com.yd.user.feign.response.sysuser.ApiScopePageResponse;
import com.yd.user.feign.response.sysuser.ApiSysUserPageResponse;
import com.yd.user.service.model.SysUser;
import org.apache.ibatis.annotations.Param;

/**
 * <p>
 * 系统用户表 Mapper 接口
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
public interface SysUserMapper extends BaseMapper<SysUser> {

    IPage<ApiSysUserPageResponse> page(@Param("page") IPage<ApiSysUserPageResponse> page,
                                       @Param("request") ApiSysUserPageRequest request,
                                       @Param("isAdmin") Boolean isAdmin,
                                       @Param("loginTenantBizId") String loginTenantBizId
                                       );

    IPage<ApiScopePageResponse> scopePage(@Param("page") Page<ApiScopePageResponse> page,
                                          @Param("request") ApiScopePageRequest request,
                                          @Param("isAdmin") Boolean isAdmin,
                                          @Param("loginTenantBizId") String loginTenantBizId);
}
