package com.yd.user.service.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.user.feign.request.relprojectmenu.ApiRelProjectMenuImportQueryMenuTreeRequest;
import com.yd.user.feign.request.relprojectmenu.ApiRelProjectMenuListPageRequest;
import com.yd.user.feign.request.relprojectmenu.ApiRelProjectMenuTreeListRequest;
import com.yd.user.feign.request.reltenantmenu.ApiRelTenantMenuTreeListRequest;
import com.yd.user.feign.response.relprojectmenu.ApiRelProjectMenuImportQueryMenuTreeResponse;
import com.yd.user.feign.response.relprojectmenu.ApiRelProjectMenuListPageResponse;
import com.yd.user.feign.response.relprojectmenu.ApiRelProjectMenuTreeListResponse;
import com.yd.user.feign.response.reltenantmenu.ApiRelTenantMenuTreeListResponse;
import com.yd.user.service.dto.RelProjectMenuDto;
import com.yd.user.service.model.RelProjectMenu;
import com.baomidou.mybatisplus.extension.service.IService;
import java.util.List;

/**
 * <p>
 * 项目-菜单关系表（正常来说一对多，加关系表方便扩展） 服务类
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
public interface IRelProjectMenuService extends IService<RelProjectMenu> {

    IPage<ApiRelProjectMenuListPageResponse> page(Page<ApiRelProjectMenuListPageResponse> page,
                                                  ApiRelProjectMenuListPageRequest request);

    List<ApiRelProjectMenuTreeListResponse> treeList(ApiRelProjectMenuTreeListRequest request);

    RelProjectMenu queryOne(Long id);

    List<RelProjectMenu> queryList(RelProjectMenuDto dto);

    List<ApiRelProjectMenuImportQueryMenuTreeResponse> importQueryMenuTreeList(ApiRelProjectMenuImportQueryMenuTreeRequest request);

    Boolean removeByProjectBizId(String projectBizId);
}
